package com.example.GasIntentTests;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;


public class MainActivity extends Activity {

  // Launch turn-by-turn navigation
  // See https://developer.android.com/training/cars/platforms/automotive-os/android-intents-automotive#tbt
  public void onNavigateLocation(View v) {
    // Get text from edittext
    EditText text = (EditText)findViewById(R.id.navigation_intent_text);
    String s = text.getText().toString().trim();

    // Create a Uri from an intent string. Use the result to create an Intent.
    Uri mapIntentUri =
        Uri.parse("google.navigation:q=" + Uri.encode(s));

    // Create an Intent from mapIntentUri. Set the action to ACTION_VIEW
    Intent mapIntent = new Intent(Intent.ACTION_VIEW, mapIntentUri);

    // Make the Intent explicit by setting the Google Maps package
    mapIntent.setPackage("com.google.android.apps.maps");

    // Attempt to start an activity that can handle the Intent
    startActivity(mapIntent);
  }

  // Search Intent
  // See https://developer.android.com/develop/devices/assistant/intents-assistant-nav-app#search-intent
  public void onSearchIntent(View v) {
    // Get text from edittext
    EditText text = (EditText)findViewById(R.id.search_intent_text);
    String s = text.getText().toString().trim();

    // Create a Uri from an search string. Use the result to create an Intent
    Uri mapSearchUri = Uri.parse("geo:0,0?q=" + Uri.encode(s));

    // Create an Intent from mapIntentUri. Set the action to ACTION_VIEW
    Intent mapIntent = new Intent(Intent.ACTION_VIEW, mapSearchUri);

    // Make the Intent explicit by setting the Google Maps package
    mapIntent.setPackage("com.google.android.apps.maps");

    // Attempt to start an activity that can handle the Intent
    startActivity(mapIntent);
  }

  public void onSelectSearchResult(View v) {
    // Get text from edittext
    EditText text = (EditText)findViewById(R.id.select_search_index_text);
    String s = text.getText().toString().trim();

    // Create a Uri from an intent string. Use the result to create an Intent.
    Uri mapSearchUri = Uri.parse("geo.action:?act=select_search_result&id=" + Uri.encode(s));

    // Create an Intent from mapIntentUri. Set the action to ACTION_VIEW
    Intent mapIntent = new Intent(Intent.ACTION_VIEW, mapSearchUri);

    // Make the Intent explicit by setting the Google Maps package
    mapIntent.setPackage("com.google.android.apps.maps");

    // Attempt to start an activity that can handle the Intent
    startActivity(mapIntent);
  }

// Custom Action Intents
// See https://developer.android.com/develop/devices/assistant/intents-assistant-nav-app#custom-action-intent
// and https://developer.android.com/training/cars/platforms/automotive-os/android-intents-automotive#action-intents
  private void geoActionIntent(String s) {
    // Create a Uri from an intent string. Use the result to create an Intent.
    Uri mapIntentUri = Uri.parse("geo.action:?act=" + Uri.encode(s));

    // Create an Intent from mapIntentUri. Set the action to ACTION_VIEW
    Intent mapIntent = new Intent(Intent.ACTION_VIEW, mapIntentUri);

    // Make the Intent explicit by setting the Google Maps package
    mapIntent.setPackage("com.google.android.apps.maps");

    // Attempt to start an activity that can handle the Intent
    startActivity(mapIntent);
  }

  public void onClickMute(View v) {
    geoActionIntent("mute");
  }

  public void onClickUnmute(View v) {
    geoActionIntent("unmute");
  }

  public void onClickShowTraffic(View v) {
    geoActionIntent("show_traffic");
  }

  public void onClickHideTraffic(View v) {
    geoActionIntent("hide_traffic");
  }

  public void onClickShowSatellite(View v) {
    geoActionIntent("show_satellite");
  }

  public void onClickHideSatellite(View v) {
    geoActionIntent("hide_satellite");
  }

  public void onClickGoBack(View v) {
    geoActionIntent("go_back");
  }

  public void onClickAllowTolls(View v) {
    geoActionIntent("allow_tolls");
  }

  public void onClickAvoidTolls(View v) {
    geoActionIntent("avoid_tolls");
  }

  public void onClickAllowFerries(View v) {
    geoActionIntent("allow_ferries");
  }

  public void onClickAvoidFerries(View v) {
    geoActionIntent("avoid_ferries");
  }

  public void onClickAllowHighways(View v) {
    geoActionIntent("allow_highways");
  }

  public void onClickAvoidHighways(View v) {
    geoActionIntent("avoid_highways");
  }

  public void onClickExitNavigation(View v) {
    geoActionIntent("exit_navigation");
  }


  public void onClickQueryNextTurn(View v) {
    geoActionIntent("query_next_turn");
  }

  public void onClickDistanceToNextTurn(View v) {
    geoActionIntent("distance_to_next_turn");
  }

  public void onClickTimeToNextTurn(View v) {
    geoActionIntent("time_to_next_turn");
  }

  public void onClickDistanceToDestination(View v) {
    geoActionIntent("distance_to_destination");
  }

  public void onClickQueryCurrentRoad(View v) {
    geoActionIntent("query_current_road");
  }

  public void onClickQueryDestination(View v) {
    geoActionIntent("query_destination");
  }

  public void onClickETA(View v) {
    geoActionIntent("eta");
  }

  public void onClickTimeToDestination(View v) {
    geoActionIntent("time_to_destination");
  }

  public void onClickApplyElectricVehicleConnectorFilter(View v) {
    geoActionIntent("apply_electric_vehicle_connector_filter");
  }

  public void onClickRemoveElectricVehicleConnectorFilter(View v) {
    geoActionIntent("remove_electric_vehicle_connector_filter");
  }

  public void onClickApplyElectricVehiclePaymentFilter(View v) {
    geoActionIntent("apply_electric_vehicle_payment_filter");
  }

  public void onClickRemoveElectricVehiclePaymentFilter(View v) {
    geoActionIntent("remove_electric_vehicle_payment_filter");
  }

  public void onClickApplyElectricVehicleFastChargingFilter(View v) {
    geoActionIntent("apply_electric_vehicle_fast_charging_filter");
  }

  public void onClickRemoveElectricVehicleFastChargingFilter(View v) {
    geoActionIntent("remove_electric_vehicle_fast_charging_filter");
  }

/*
report_crash
report_hazard
report_police
report_road_closure
report_traffic
*/

  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
      setContentView(R.layout.main_layout);

      Intent intent = getIntent();
      String actions = intent.getAction();

      Log.v("GasIntentTests", actions);

      if(actions.equals("android.intent.action.VIEW")) {
        Uri data = intent.getData();

        TextView text = (TextView)findViewById(R.id.assistant_intent_text);
        text.setText(data.toString());
        //String type = intent.getType();
      }
    }
}
